function mpc = Network4																										
%% INESC TEC 06/07/2020																										
%% MATPOWER Case Format : Version 2																										
mpc.version = '2';																										
																										
%%-----  Power Flow Data  -----%%																										
%% system MVA base																										
mpc.baseMVA = 100;																										
																										
%% system voltage levels (kV)																										
mpc.V_levels = [																										
	10	60																								
];																										
																										
%% bus data																										
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	hasGEN	isLOAD	SNOM_MVA	SX	SY	GX	GY						
mpc.bus = [																										
	1	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0	0	0	0	0;						
	2	2	0.00E+00	0.00E+00	1.40E-02	0.00E+00	1	1	0	60	1	1.1	0.9	1	0	0	0	0	0	0;						
	3	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0	0	0	0	0;						
	4	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0	0	0	0	0;						
	5	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0	0	0	0	0;						
	6	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	7	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	8	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	9	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	10	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	11	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	12	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	13	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	14	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	15	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1.00E+00	1.00E+00	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	16	1	3.20E-02	0.00E+00	0.00E+00	0.00E+00	1.00E+00	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	17	1	1.54E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	18	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	19	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	20	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	21	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	22	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	23	1	1.78E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	24	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	25	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	26	1	2.60E-01	0.00E+00	0.00E+00	0.00E+00	1.00E+00	1.00E+00	0	10	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	27	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1.00E+00	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	28	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	29	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	30	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	31	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	32	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	33	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	34	1	2.90E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	35	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	36	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	37	1	1.80E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	38	1	7.71E-02	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	39	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	40	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	41	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	42	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	43	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	44	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	45	1	1.88E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	4	0	0	0	0;						
	46	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	47	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	48	1	7.92E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	49	1	1.21E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.32	0	0	0	0;						
	50	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	51	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	52	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	53	1	1.21E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.25	0	0	0	0;						
	54	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	55	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	56	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	57	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	58	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	59	1	1.14E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.177	0	0	0	0;						
	60	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	61	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	62	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	63	1	1.83E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.315	0	0	0	0;						
	64	1	2.48E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	65	1	3.78E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	66	1	2.09E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	67	1	2.29E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.4	0	0	0	0;						
	68	1	1.59E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	3	0	0	0	0;						
	69	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	70	1	1.30E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	1.4	0	0	0	0;						
	71	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	72	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	73	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	74	1	5.28E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.9	0	0	0	0;						
	75	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	76	1	1.76E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	77	1	4.20E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	1	0	0	0	0;						
	78	1	2.93E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	1.26	0	0	0	0;						
	79	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	80	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	81	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	82	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	83	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	84	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	85	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	86	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	87	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.5	0	0	0	0;						
	88	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	89	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	90	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	91	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	92	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	93	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	94	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	95	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	96	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	97	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	98	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	99	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	100	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	101	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	102	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	999.999	0	0	0	0;						
	103	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	104	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	105	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	106	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	107	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	108	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	109	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.16	0	0	0	0;						
	110	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	111	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	112	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	113	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.63	0	0	0	0;						
	114	1	3.99E-01	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	1	0.8	0	0	0	0;						
	115	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	116	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	117	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	118	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	119	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	120	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	121	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	122	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	123	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	124	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	125	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	126	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	127	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	128	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	129	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	130	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	131	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	132	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	133	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	134	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	135	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	136	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	137	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	138	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	139	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	140	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	141	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	142	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	143	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	144	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	145	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	146	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	147	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	148	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	149	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	150	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	151	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	152	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	153	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	154	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	155	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	156	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	157	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	158	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	159	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	160	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	161	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	162	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	163	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	164	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	165	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	166	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	167	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	168	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	169	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	170	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	171	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	172	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	173	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	174	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	175	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	176	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	177	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	178	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	179	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	180	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	181	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	182	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	183	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	184	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	185	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	186	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	187	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	188	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	189	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	190	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	191	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	192	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	193	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	194	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	195	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	196	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	197	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	198	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	199	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	200	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	201	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	202	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	203	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	204	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	205	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	206	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	207	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	208	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	209	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	210	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	211	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	212	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	213	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	214	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	215	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	216	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	217	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	218	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	219	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	220	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
	221	1	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1	1	0	10	1	1.1	0.9	0	0	0	0	0	0	0;						
];																										
																										
%% generator data																										
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	ID				
mpc.gen = [																										
	2	0	0	10000	-10000	1	100	1	9999	-9999	0	0	0	0	0	0	0	0	0	0	0	1;
];																										
																										
%% branch data																										
%	fbus	tbus	r	x	b	rateA (typical)	rateB (summer)	rateC (winter)	ratio	angle	status	angmin	angmax	step_size	actTap	minTap	maxTap	normalTap	nominalRatio	r_ip	r_n	r0	x0	b0	length (meter)	NormSTAT
mpc.branch = [																										
	133	132	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	184	70	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	4.49	1;
	184	58	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	4.47	1;
	199	156	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	216	215	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	63	153	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	9.61	1;
	138	137	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	139	138	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	137	135	0.00E+00	1.00E-04	0.00E+00	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	136	134	0.00E+00	1.00E-04	0.00E+00	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	180	178	0.00E+00	1.00E-04	0.00E+00	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	187	175	0.00E+00	1.00E-04	0.00E+00	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	205	197	0.00E+00	1.00E-04	0.00E+00	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	206	205	0.00E+00	1.00E-04	0.00E+00	173.1878	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	206	148	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	151	148	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	214	164	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	209	201	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	214	201	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	209	177	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	202	190	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	200	124	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	217	183	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	220	217	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	171	129	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	143	142	6.30E-06	1.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.04	1;
	197	196	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	188	187	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	191	188	0.00E+00	1.00E-04	0.00E+00	1.73E+02	1.73E+02	1.73E+02	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	4.00E-02	1;
	144	140	0.00E+00	1.00E-04	0.00E+00	1.73E+02	1.73E+02	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	4.00E-02	1;
	169	165	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	173	172	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	160	157	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	60	152	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.24	1;
	59	153	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.42	1;
	221	218	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	204	203	6.30E-06	1.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.04	1;
	118	117	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	119	118	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	125	117	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	212	207	6.30E-06	1.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.04	1;
	123	121	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	62	152	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.29	1;
	61	152	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.2051	173.2051	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	9.47	1;
	181	179	6.30E-06	1.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.04	1;
	194	193	6.30E-06	1.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.04	1;
	219	211	0.00E+00	1.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	2	1	1.55E-02	5.00E-01	0.00E+00	2.00E+01	20	20	1	0	1	-360	360	1.4955	12	1	23	12	0.9514	0.00E+00	0.00E+00	1.55E-02	4.50E-01	0.00E+00	0	1;
	145	147	0.00E+00	2.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	191	196	0.00E+00	2.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.1	1;
	151	164	0.00E+00	2.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.08	1;
	116	111	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.17	1;
	11	117	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.32	1;
	125	8	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.36	1;
	124	35	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.17	1;
	31	123	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.13	1;
	123	32	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.17	1;
	15	124	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.13	1;
	23	126	0.00E+00	7.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.49	1;
	66	174	0.00E+00	9.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.3	1;
	133	81	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.23	1;
	130	25	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.16	1;
	129	57	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.14	1;
	18	129	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	133	80	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.19	1;
	141	28	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	193	108	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.25	1;
	194	100	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.3	1;
	194	101	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.3	1;
	167	42	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.05	1;
	134	30	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	6	125	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.32	1;
	134	29	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	131	105	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.16	1;
	208	27	0.00E+00	5.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.23	1;
	65	158	6.30E-06	1.00E-03	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	6.41	1;
	144	20	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	144	22	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	210	114	4.73E-06	7.00E-04	9.99E-11	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	4.73E-06	1.04E-05	9.99E-11	6.37	1;
	147	72	0.00E+00	5.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	162	213	4.24E-02	2.53E-02	3.68E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.69E-01	1.34E-01	3.68E-05	267.33	1;
	216	103	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.23	1;
	216	104	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.24	1;
	147	33	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	24	149	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.15	1;
	75	182	6.30E-06	6.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	6.37	1;
	219	36	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	38	154	0.00E+00	7.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.41	1;
	220	56	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.37	1;
	55	220	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.33	1;
	162	39	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.17	1;
	143	107	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.28	1;
	143	106	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.18	1;
	213	150	1.59E-02	1.02E-02	1.37E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.01E-01	5.02E-02	1.37E-05	103.11	1;
	150	110	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.14	1;
	161	47	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.24	1;
	160	46	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	160	44	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	67	115	6.30E-06	5.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	6.31	1;
	161	99	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.2	1;
	37	128	6.30E-06	7.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	6.47	1;
	146	109	3.15E-06	9.00E-04	6.66E-11	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	3.15E-06	6.90E-06	6.66E-11	0.06	1;
	159	53	0.00E+00	7.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.5	1;
	141	121	3.81E-02	2.28E-02	3.30E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.42E-01	1.20E-01	3.30E-05	240.41	1;
	52	170	6.30E-06	5.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.25	1;
	77	163	6.30E-06	7.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	6.39	1;
	164	12	0.00E+00	9.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.06	1;
	170	51	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.23	1;
	169	50	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.22	1;
	169	54	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	172	89	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.19	1;
	172	90	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.23	1;
	206	174	2.81E-01	1.62E-01	2.44E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.78E+00	8.89E-01	2.44E-04	1759.64	1;
	49	168	6.30E-06	7.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	6.38	1;
	140	156	9.08E-03	6.19E-03	7.88E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.77E-02	2.87E-02	7.88E-06	64.23	1;
	130	165	2.13E-02	1.35E-02	1.85E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.35E-01	6.74E-02	1.85E-05	135.44	1;
	158	149	4.91E-02	1.65E-02	1.72E-05	3.97E+00	3.7066	4.1742	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.87E-01	8.18E-02	1.72E-05	161.92	1;
	1	191	0.00E+00	8.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.13	1;
	185	79	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.33	1;
	182	198	1.52E-02	9.90E-03	1.32E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	9.67E-02	4.82E-02	1.32E-05	100.11	1;
	204	83	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.24	1;
	204	84	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.3	1;
	203	82	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.2	1;
	212	85	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.3	1;
	167	43	0.00E+00	5.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.65	1;
	212	86	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.33	1;
	200	145	1.59E-02	1.05E-02	1.38E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.01E-01	5.04E-02	1.38E-05	102.54	1;
	5	175	0.00E+00	5.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.06	1;
	217	198	3.17E-02	1.91E-02	2.75E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.02E-01	1.00E-01	2.75E-05	202.46	1;
	188	3	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.02	1;
	166	167	7.88E-06	4.00E-04	1.67E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.88E-06	1.73E-05	1.67E-10	0.06	1;
	180	19	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.23	1;
	78	168	1.81E-02	1.22E-02	1.57E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.15E-01	5.73E-02	1.57E-05	124.35	1;
	4	175	0.00E+00	4.00E-04	0.00E+00	1.73E+02	1.73E+02	1.73E+02	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	2.00E-02	1;
	21	180	0.00E+00	3.00E-04	0.00E+00	1.73E+02	1.73E+02	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	1.90E-01	1;
	178	215	1.63E-02	1.06E-02	1.41E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.04E-01	5.16E-02	1.41E-05	110.67	1;
	120	182	7.45E-03	5.36E-03	6.46E-06	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	4.73E-02	2.36E-02	6.46E-06	51.58	1;
	26	176	0.00E+00	9.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.34	1;
	150	5	9.01E-02	5.26E-02	7.81E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.72E-01	2.85E-01	7.81E-05	572.2	1;
	171	174	1.09E-02	7.32E-03	9.44E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.92E-02	3.44E-02	9.44E-06	72.49	1;
	171	176	8.50E-03	5.86E-03	7.37E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.40E-02	2.69E-02	7.37E-06	58.38	1;
	196	173	4.67E-02	2.82E-02	4.05E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.96E-01	1.48E-01	4.05E-05	296.03	1;
	186	69	0.00E+00	5.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.21	1;
	145	173	2.31E-02	1.44E-02	2.01E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.47E-01	7.31E-02	2.01E-05	149.23	1;
	189	141	2.92E-02	1.79E-02	2.53E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.85E-01	9.22E-02	2.53E-05	184.75	1;
	195	177	1.15E-01	6.75E-02	1.00E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.33E-01	3.65E-01	1.00E-04	731.46	1;
	120	154	7.01E-02	4.11E-02	6.07E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	4.45E-01	2.22E-01	6.07E-05	443.5	1;
	189	92	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	181	149	3.74E-02	1.29E-02	1.34E-05	3.97E+00	3.7066	4.1742	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.44E-01	6.32E-02	1.34E-05	125.65	1;
	166	16	8.81E-03	6.74E-03	7.64E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.60E-02	2.79E-02	7.64E-06	67.6	1;
	179	153	0.00E+00	5.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.04	1;
	152	179	1.26E-05	7.00E-04	2.66E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.26E-05	2.76E-05	2.66E-10	0.12	1;
	213	97	6.30E-06	4.00E-04	1.33E-10	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.30E-06	1.38E-05	1.33E-10	0.17	1;
	87	122	3.25E-02	2.03E-02	2.83E-05	6.27E+00	5.8717	6.5991	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.07E-01	1.03E-01	2.83E-05	208.2	1;
	88	122	1.58E-06	6.00E-04	3.33E-11	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.58E-06	3.45E-06	3.33E-11	0.04	1;
	205	203	1.86E-01	1.08E-01	1.61E-04	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.18E+00	5.88E-01	1.61E-04	1166.11	1;
	155	13	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.19	1;
	155	14	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.23	1;
	195	68	0.00E+00	1.30E-03	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.36	1;
	48	187	1.22E-02	9.50E-03	1.06E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.78E-02	3.87E-02	1.06E-05	90.03	1;
	159	177	9.11E-02	5.37E-02	7.90E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.78E-01	2.88E-01	7.90E-05	580.33	1;
	17	127	0.00E+00	9.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	6.57	1;
	192	64	3.15E-06	5.00E-04	6.66E-11	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	3.15E-06	6.90E-06	6.66E-11	6.32	1;
	128	142	1.11E-02	7.33E-03	9.60E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.03E-02	3.50E-02	9.60E-06	71.31	1;
	142	148	1.80E-01	1.05E-01	1.56E-04	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.14E+00	5.70E-01	1.56E-04	1128.17	1;
	210	34	4.19E-02	2.60E-02	3.63E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.66E-01	1.32E-01	3.63E-05	271.49	1;
	181	192	7.44E-02	2.36E-02	2.48E-05	3.97E+00	3.7066	4.1742	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.78E-01	1.20E-01	2.48E-05	236.84	1;
	137	93	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.27	1;
	138	94	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.3	1;
	139	95	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.31	1;
	199	41	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.17	1;
	199	40	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.13	1;
	219	195	1.21E-01	7.00E-02	1.04E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.65E-01	3.81E-01	1.04E-04	755.91	1;
	202	91	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.22	1;
	202	98	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	200	178	2.29E-02	1.43E-02	1.98E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.45E-01	7.24E-02	1.98E-05	147.04	1;
	190	165	1.80E-02	1.14E-02	1.56E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.15E-01	5.71E-02	1.56E-05	113.77	1;
	115	9	1.59E-01	7.72E-02	1.08E-04	3.97E+00	3.7066	4.1742	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	8.65E-01	4.17E-01	1.08E-04	820.89	1;
	127	132	4.92E-03	4.01E-03	4.27E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	3.13E-02	1.56E-02	4.27E-06	35.53	1;
	126	193	1.19E-01	6.95E-02	1.04E-04	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.59E-01	3.78E-01	1.04E-04	749.96	1;
	126	215	2.47E-02	1.51E-02	2.14E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.57E-01	7.82E-02	2.14E-05	164.28	1;
	128	207	8.49E-02	4.96E-02	7.36E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.39E-01	2.68E-01	7.36E-05	531.67	1;
	136	210	2.31E-02	1.42E-02	2.00E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.47E-01	7.30E-02	2.00E-05	148.46	1;
	136	207	1.28E-02	8.49E-03	1.11E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	8.10E-02	4.04E-02	1.11E-05	82.55	1;
	73	208	7.26E-02	4.31E-02	6.30E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	4.61E-01	2.30E-01	6.30E-05	455.71	1;
	74	198	3.15E-06	7.00E-04	6.66E-11	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	3.15E-06	6.90E-06	6.66E-11	6.28	1;
	45	211	7.68E-02	4.89E-02	7.04E-05	6.27E+00	5.8717	6.5991	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.12E-01	2.57E-01	7.04E-05	516.89	1;
	157	121	1.31E-02	8.68E-03	1.13E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	8.31E-02	4.14E-02	1.13E-05	84.9	1;
	186	155	8.43E-02	4.94E-02	7.31E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.35E-01	2.67E-01	7.31E-05	530.45	1;
	151	166	2.65E-01	1.54E-01	2.38E-04	6.04E+00	5.6465	6.3566	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.72E+00	8.60E-01	2.38E-04	1700.4	1;
	127	186	5.66E-03	4.33E-03	4.90E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	3.59E-02	1.79E-02	4.90E-06	39.87	1;
	157	71	2.09E-03	2.80E-03	1.81E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.33E-02	6.62E-03	1.81E-06	17.06	1;
	139	96	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.36	1;
	131	185	2.60E-02	1.61E-02	2.26E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.65E-01	8.23E-02	2.26E-05	166.58	1;
	115	192	3.44E-02	1.29E-02	1.42E-05	3.97E+00	3.7066	4.1742	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.42E-01	6.36E-02	1.42E-05	129.3	1;
	3	190	1.33E-01	7.73E-02	1.15E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	8.46E-01	4.21E-01	1.15E-04	836.43	1;
	209	189	9.99E-02	5.86E-02	8.66E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	6.34E-01	3.16E-01	8.66E-05	631.37	1;
	102	211	0.00E+00	6.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	4.68	1;
	140	201	1.90E-01	1.10E-01	1.65E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.21E+00	6.02E-01	1.65E-04	1193.86	1;
	197	158	2.50E-01	1.31E-01	1.90E-04	3.97E+00	3.7066	4.1742	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.46E+00	7.14E-01	1.90E-04	1413.64	1;
	135	214	2.36E-01	1.36E-01	2.04E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.50E+00	7.46E-01	2.04E-04	1475.09	1;
	76	120	4.73E-06	9.00E-04	9.99E-11	7.88E+00	7.8808	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	4.73E-06	1.04E-05	9.99E-11	6.41	1;
	183	122	5.25E-02	3.10E-02	4.55E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	3.33E-01	1.66E-01	4.55E-05	330.78	1;
	218	170	3.22E-02	1.96E-02	2.79E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	2.04E-01	1.02E-01	2.79E-05	203.61	1;
	221	7	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.26	1;
	163	154	2.34E-02	1.46E-02	2.03E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.49E-01	7.42E-02	2.03E-05	153.33	1;
	218	131	1.68E-02	1.08E-02	1.46E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.07E-01	5.32E-02	1.46E-05	108.28	1;
	221	112	0.00E+00	4.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.18	1;
	116	146	3.06E-03	2.95E-03	2.65E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.94E-02	9.68E-03	2.65E-06	25.35	1;
	4	116	1.25E-01	7.26E-02	1.08E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.94E-01	3.95E-01	1.08E-04	789.41	1;
	161	176	2.63E-03	2.70E-03	2.28E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.67E-02	8.31E-03	2.28E-06	22.28	1;
	10	118	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.32	1;
	162	185	3.06E-02	1.88E-02	2.65E-05	7.07E+00	6.7723	7.8808	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.94E-01	9.67E-02	2.65E-05	194.15	1;
	146	168	1.24E-01	7.21E-02	1.08E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.90E-01	3.93E-01	1.08E-04	781.03	1;
	119	135	1.51E-02	9.73E-03	1.31E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	9.59E-02	4.78E-02	1.31E-05	96.36	1;
	208	130	1.14E-02	7.62E-03	9.88E-06	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	7.24E-02	3.60E-02	9.88E-06	74.79	1;
	156	132	8.58E-02	5.01E-02	7.43E-05	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	5.45E-01	2.71E-01	7.43E-05	541.08	1;
	183	184	0.00E+00	7.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.13	1;
	113	119	0.00E+00	3.00E-04	0.00E+00	1.73E+02	173.1878	173.1878	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.00E+00	0.32	1;
	163	159	1.77E-01	1.02E-01	1.54E-04	7.07E+00	6.7723	8.2619	0	0	1	-360	360	0	0	0	0	0	0	0.00E+00	0.00E+00	1.13E+00	5.61E-01	1.54E-04	1112.63	1;
];																										
																										
%%-----  OPF Data  -----%%																										
%% generator cost data																										
%	1	startup	shutdown	n	x1	y1	...	xn	yn																	
%	2	startup	shutdown	n	c(n-1)	...	c0																			
mpc.gencost = [																										
	2	0	0.00E+00	3.00E+00	0.00E+00	0.00E+00	  0.00;																			
];																										
																										
% mpc.tans																										
% from bus	to bus	min	max	totaltaps	tap																					
mpc.trans=[2	1	0.8355	1.16E+00	2.30E+01	12];																					
																										
